// DataOut.cpp: CDataOut NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "GetStatus.h"
#include "DataOut.h"
#include "MyGlobal.h"
#include "PortOpen.h"

#include <WINIOCTL.H>
//#include "NTDDPAR.H"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////

CDataOut::CDataOut()
{

}

CDataOut::~CDataOut()
{

}

BOOL CDataOut::TransmissionData(unsigned char *lpBuffer, unsigned long lLength)
{
	DWORD dwStartTime;
	DWORD dwWrLength;
	DWORD dwStartTimeX;

	dwStartTimeX = ::GetTickCount();

	while(lLength)
	{
		dwStartTime = ::GetTickCount();

		while(CheckPort() == FALSE)
		{
			::Sleep(100);

			if((::GetTickCount() - dwStartTime) >= 3000)						// T
			{
				return FALSE;
			}
		}

		if(lLength >= 2)    ::WriteFile(hCommPort, lpBuffer, 2,       &dwWrLength, NULL);
		else			    ::WriteFile(hCommPort, lpBuffer, lLength, &dwWrLength, NULL);

		lpBuffer += dwWrLength;
		lLength  -= dwWrLength;

		if(dwWrLength)
		{
			dwStartTimeX = ::GetTickCount();
		}
		else
		{
			if((::GetTickCount() - dwStartTimeX) >= 3000)
			{
				::PurgeComm(hCommPort, PURGE_RXABORT | PURGE_RXCLEAR);

				dwStartTimeX = ::GetTickCount();
			}
		}
	}

	return TRUE;

}

BOOL CDataOut::CheckPort()
{
	if(iPortCheck == 0xff)															// Port Check Disable
	{
		return TRUE;
	}

	DWORD dwStatus;
	if(::GetCommModemStatus(hCommPort, &dwStatus) == FALSE)
	{
		return FALSE;
	}

	switch(iProtocol)
	{
		default :	if(!(dwStatus & MS_CTS_ON))
					{
						return FALSE;
					}
					break;
		case 0 :	break;														// Xon/Xoff mode
		case 1 :	if(!(dwStatus & MS_CTS_ON))									// CTS
					{
						return FALSE;
					}
					break;
		case 2 :	if(!(dwStatus & MS_DSR_ON))									// DSR
					{
						return FALSE;
					}
					break;
		case 3 :	if(!(dwStatus & MS_DSR_ON) && !(dwStatus & MS_CTS_ON))		// CTS & DSR
					{
						return FALSE;
					}
					break;
		case 4 :	break;														// All Disable
	}


	return TRUE;
}
